#ifndef _SEEARCHNVS_H
#define _SEEARCHNVS_H

#include <map>
#include <vector>
#include "Include/CLS_NetAdmin_Interface.h"
#include "Include/RegServerTypes.h"
#include "MainViewDlg.h"
#include "afxwin.h"
#include "SortListCtrl.h"

using namespace std;

#define INSERT_PRODUCTMODEL(id)      m_mapProductModelName.insert(pair<int, CString>(id, #id));
#define INSERT_DEVICETYPE(type)      m_vectDeviceType.push_back(type);

// CSearchNVS dialog
class CSearchNVS : public CDialog
{
	DECLARE_DYNAMIC(CSearchNVS)

public:
	CSearchNVS(CWnd* pParent = NULL);   // standard constructor
	virtual ~CSearchNVS();
	DECLARE_MESSAGE_MAP()
	enum { IDD = IDD_DIALOG_SEARCHNVS };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnOK();

public:
	virtual BOOL OnInitDialog();
	afx_msg void OnClose();
	afx_msg void OnDestroy();
	afx_msg void OnBnClickedButtonRefresh();
	afx_msg void OnBnClickedButtonAdd();
	afx_msg void OnCbnSelchangeComboConnectMode();
	afx_msg void OnNMDblclkListServer(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg LRESULT	OnUpdateList(WPARAM wParam, LPARAM lParam);	
	afx_msg LRESULT	OnAddNvsItem(WPARAM wParam, LPARAM lParam);	

	int Init(int _iID, CMainViewDlg* _pdlgMainView);
	int AddByIP(PTDEVICE _pDevice);
	int AddByDDNS(REG_DNS &_regDNS);
	int AddByDSM(st_NvsSingle &_regDNS);

	static void __stdcall GetIPList(PTDEVICE _pDevice);
	static int __stdcall GetDDNSList(int _iCount,REG_DNS *_regDNS);
	static int __stdcall GetDSMList(int _iCount,st_NvsSingle *_regNVS);
	static unsigned int __stdcall ThreadRefresh(VOID* pVoid);

	int AddNvs(int _iItem);
	int AddNvsEx(int _iItem);
	int SendMsgToMainDlg(UINT _iMsgID, WPARAM _wParam, LPARAM _lpParam);

private:
	void InitializeProductModelName();
	CString GetProductModelName(int _iModel);
	void InitializeDeviceTypeName();
	CString GetDeviceTypeName(int _iType);
	int AddNvsItem(CString _strServerIP,int _iChannelNum,int _iPort ,CString _strServerType,CString _strFactroyID ,CString _strServerName,CString _strProxyIP);
	void SearchByIP();
	void SearchByDDNS();
	void SearchByDSM();
	void Refresh();
	CString GetNvsType(int _iNvsType);
	bool LogonReg();
	
public:
	int		m_iConnetMode;
	bool    m_blRefresh;
	bool	m_blExit;
	CString m_strHostIP;
	
	CSortListCtrl m_lvServer;
	map<int, CString>    m_mapProductModelName;
	
private:
	int m_iID;
	CComboBox m_cboConnectMode;
	
	vector<CString>	m_vectDeviceType;
	HANDLE m_hThread;
	int m_iRegID;
	int m_iRegPort;
	char m_cRegIP[32];
	char m_cRegUser[32];
	char m_cRegPwd[32];
	CMainViewDlg* m_pdlgMainView;

	HANDLE m_hAddThread;

	static CSearchNVS* m_pSelf;
	static HWND s_hWnd;

	HANDLE m_hLogonRegThread;
	unsigned int m_dwThreadID;
	static unsigned int WINAPI LogonRegThread(LPVOID _Param);
	
public:
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
private:
	CComboBox m_cboServerInterface;
public:
	afx_msg void OnCbnSelchangeComboLocalIp();
};

#endif